<div class="row gy-4 mb-4">
    <div class="col-sm-5 col-md-4 col-xxl-2">
        <label class="form--label {{ $product?->main_image ? "" : "required" }}">@lang('Main Image')</label>
        <x-frontend-image-uploader name="main_image" :imagePath="$product?->mainImage() ?? null" type="product" :required="($product?->main_image? false : true)" />
    </div>
    <div class="col-sm-7 col-md-8 col-xxl-10">
        @if ($product->product_type == Status::PRODUCT_TYPE_VARIABLE)
            <div class="variant-upload-note">
                <h6 class="title">@lang('Variant-wise Image Upload (Quick Guide)')</h6>
                <ul class="instruction">
                    <li>@lang('Upload images for each automatically created variant section.')</li>
                    <li>@lang('Use clear, high-quality images with exact size') <strong>{{ getFileSize('product') }}
                            @lang('pixels')</strong>, JPG, JPEG or PNG @lang('format and consistent background.')</li>
                    <li>@lang('Include multiple angles: front, back, side, and close-up shots to show product details.')</li>
                    <li>@lang('Ensure each image accurately represents the variant section it belongs to.')</li>
                    <li>@lang('Check that colors, patterns, and textures in the images match the actual product.')</li>
                </ul>
            </div>
        @else
            @include($activeTemplate . '.vendor.product.forms.general_media')
        @endif
    </div>
</div>

@if ($product->product_type == Status::PRODUCT_TYPE_VARIABLE)
    @include($activeTemplate . '.vendor.product.forms.variants_media')
@endif


@pushOnce('style-lib')
    <link rel="stylesheet" href="{{ asset($activeTemplateTrue . 'css/image-uploader.min.css') }}">
@endPushOnce

@pushOnce('script-lib')
    <script src="{{ asset($activeTemplateTrue . 'js/image-uploader.min.js') }}"></script>
@endPushOnce

@push('style')
    <style>
        @media screen and (max-width: 575px) {
            .image--uploader {
                width: 160px;
            }
        }

        .variant-upload-note {
            margin-top: 28px;
        }

        @media screen and (max-width: 575px) {
            .variant-upload-note {
                margin-top: 0px;
            }
        }

        .variant-upload-note .title {
            margin-bottom: 8px;

        }

        .variant-upload-note .instruction li::before {
            content: '\f05a';
            font-size: 16px;
            font-weight: 900;
            font-family: 'Line Awesome Free';
            margin-right: 8px;
        }

        .variant-upload-note .instruction li {
            font-size: 14px;
            color: hsl(var(--black)/0.5);
            font-weight: 500;
        }

        .variant-upload-note .instruction li strong {
            font-weight: 700;
            color: hsl(var(--black)/0.8);
        }

        .variant-upload-note .instruction li:not(:last-child) {
            margin-bottom: 12px;
        }

        @media screen and (max-width: 575px) {
            .variant-upload-note .instruction li:not(:last-child) {
                margin-bottom: 6px;
            }
        }
    </style>
@endpush
