@extends($activeTemplate . 'layouts.auth')
@section('content')
    @php
        $sectionName = 'profile_complete';
        $content = getContent($sectionName . '.content', true)?->data_values ?? null;
        $elements = getContent($sectionName . '.element', orderById: true);
    @endphp
    <h2 class="account-main__title">{{ __($content?->form_heading) }}</h2>
    <form method="POST" action="{{ route('user.data.submit') }}" class="account-form">
        @csrf
        <div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    <label class="form--label">@lang('Username')</label>
                    <input type="text" class="form--control checkUser" name="username" value="{{ old('username') }}"
                        required>
                    <small class="text--danger usernameExist"></small>
                </div>
            </div>

            <div class="col-md-6">

                <div class="form-group">
                    <label class="form--label">@lang('Country')</label>
                    <select name="country" class="form--control select2" required>
                        @foreach ($countries as $key => $country)
                            <option data-mobile_code="{{ $country->dial_code }}" value="{{ $country->country }}"
                                data-code="{{ $key }}">
                                {{ __($country->country) }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="col-md-6">
                <div class="form-group">
                    <label class="form--label">@lang('Mobile')</label>
                    <div class="input-group input--group">
                        <span class="input-group-text mobile-code">

                        </span>
                        <input type="hidden" name="mobile_code">
                        <input type="hidden" name="country_code">
                        <input type="number" name="mobile" value="{{ old('mobile') }}"
                            class="form-control form--control checkUser" required>
                    </div>
                    <small class="text--danger mobileExist"></small>
                </div>
            </div>
            <div class="form-group col-sm-6">
                <label class="form--label">@lang('Address')</label>
                <input type="text" class="form--control" name="address" value="{{ old('address') }}">
            </div>
            <div class="form-group col-sm-6">
                <label class="form--label">@lang('State')</label>
                <input type="text" class="form--control" name="state" value="{{ old('state') }}">
            </div>
            <div class="form-group col-sm-6">
                <label class="form--label">@lang('Zip Code')</label>
                <input type="text" class="form--control" name="zip" value="{{ old('zip') }}">
            </div>
            <div class="form-group col-sm-6">
                <label class="form--label">@lang('City')</label>
                <input type="text" class="form--control" name="city" value="{{ old('city') }}">
            </div>
        </div>
        <div class="form-group">
            <button type="submit" class="btn btn--base w-100">
                @lang('Submit')
            </button>
        </div>
    </form>
@endsection

@push('script')
    <script>
        (function($) {
            "use strict";

            @if ($mobileCode)
                $(`option[data-code={{ $mobileCode }}]`).attr('selected', '');
            @endif


            $('select[name=country]').on('change', function() {
                $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
                $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
                $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));
                var value = $('[name=mobile]').val();
                var name = 'mobile';
                checkUser(value, name);
            });

            $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
            $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
            $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));


            $('.checkUser').on('focusout', function(e) {
                var value = $(this).val();
                var name = $(this).attr('name')
                checkUser(value, name);
            });

            function checkUser(value, name) {
                var url = '{{ route('user.checkUser') }}';
                var token = '{{ csrf_token() }}';

                if (name == 'mobile') {
                    var mobile = `${value}`;
                    var data = {
                        mobile: mobile,
                        mobile_code: $('.mobile-code').text().substr(1),
                        _token: token
                    }
                }
                if (name == 'username') {
                    var data = {
                        username: value,
                        _token: token
                    }
                }
                $.post(url, data, function(response) {
                    if (response.data != false) {
                        $(`.${response.type}Exist`).text(`${response.field} already exist`);
                    } else {
                        $(`.${response.type}Exist`).text('');
                    }
                });
            }
        })(jQuery);
    </script>
@endpush
